<?php
/*
 * 2012-2018 Webtet
 *
 * Webtet Countdown Discount Timer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Webtet
 *  @copyright 2012-2018 Webtet
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
*/
if (!defined('_PS_VERSION_'))
	exit;		
	class TetCountdown extends Module
{	
	private $_html = '';
	private $_postErrors = array();
	
	public function __construct()
	{
			$this->name = 'tetcountdown';
			$this->tab = 'front_office_features';
			$this->version = '1.0.1';
			$this->dir = '/modules/tetcountdown/';
			$this->author = 'Webtet';
			if(version_compare(_PS_VERSION_, '1.6.0.0', '>='))
			$this->bootstrap = true;
			$this->display = 'view';
			parent::__construct();
			$this->displayName = $this->l('Countdown Discount Timer Module');
			$this->description = $this->l('Display Countdown Discount Timer Module');
			$this->confirmUninstall = $this->l('Are you sure you want to uninstall?'); 
		}
		public function install()
		{
			return parent::install() &&
			$this->registerHook('displayHeader') &&
			$this->registerHook('displaytetcountdown') &&
			Configuration::updateValue('configcount_input1', '#ff9300') &&
			Configuration::updateValue('COUNTCONFIG_1', 'Hurry Up! Offer ends in:') &&
			Configuration::updateValue('COUNTCONFIG_2', '') &&
			Configuration::updateValue('COUNTCONFIG_3', '2022-02-28 00:00:00') &&
			Configuration::updateValue('COUNTCONFIG_4', 'Hurry Up! Offer ends in:') &&
			Configuration::updateValue('COUNTCONFIG_6', '2022-02-25 00:00:00') &&
			Configuration::updateValue('configcount_radio1', 1) &&
			Configuration::updateValue('configcount_radio2', 1) &&
			Configuration::updateValue('configcount_radio3', 1) &&
			Configuration::updateValue('configcount_radio4', 1) &&
			Configuration::updateValue('configcount_radio5', 0) &&
			Configuration::updateValue('configcount_radio6', 1) &&
			Configuration::updateValue('configcount_input2', '#405ba8') &&
			Configuration::updateValue('configcount_input3', '') &&
			Configuration::updateValue('COUNTCONFIG_7', '-1') &&
			Configuration::updateValue('COUNTCONFIG_8', '0') &&
			Configuration::updateValue('COUNTCONFIG_9', '50') &&
			Configuration::updateValue('COUNTCONFIG_10', '#dddddd') &&
			Configuration::updateValue('configcount_input4', '50px') &&
			Configuration::updateValue('configcount_radio7', '1') &&
			Configuration::updateValue('configcount_radio8', 1) &&
			Configuration::updateValue('COUNTCONFIG_11', '1') &&
			Configuration::updateValue('COUNTCONFIG_12', '1') &&
			Configuration::updateValue('COUNTCONFIG_13', '1') &&
			Configuration::updateValue('COUNTCONFIG_14', '0') &&
			Configuration::updateValue('COUNTCONFIG_15', '1') &&
			Configuration::updateValue('COUNTCONFIG_16', '1') &&
			Configuration::updateValue('COUNTCONFIG_17', 'up') &&
			Configuration::updateValue('COUNTCONFIG_18', '-1') &&
			Configuration::updateValue('COUNTCONFIG_19', '0') &&
			Configuration::updateValue('COUNTCONFIG_20', '50') &&
			Configuration::updateValue('COUNTCONFIG_21', '60px') &&
			Configuration::updateValue('COUNTCONFIG_22', '1') &&
			Configuration::updateValue('COUNTCONFIG_23', '1') &&
			Configuration::updateValue('COUNTCONFIG_24', '1') &&
			Configuration::updateValue('COUNTCONFIG_25', '1') &&
			Configuration::updateValue('COUNTCONFIG_26', '0') &&
			Configuration::updateValue('COUNTCONFIG_27', '#000000') &&
			Configuration::updateValue('COUNTCONFIG_28', '1') &&
			Configuration::updateValue('COUNTCONFIG_29', 'eee') &&
			Configuration::updateValue('COUNTCONFIG_30', 'down') &&
			Configuration::updateValue('COUNTCONFIG_31', '-1') &&
			Configuration::updateValue('COUNTCONFIG_32', '0') &&
			Configuration::updateValue('COUNTCONFIG_33', '50') &&
			Configuration::updateValue('COUNTCONFIG_34', '70px') &&
			Configuration::updateValue('COUNTCONFIG_35', '1') &&
			Configuration::updateValue('COUNTCONFIG_36', '1') &&
			Configuration::updateValue('COUNTCONFIG_37', '1') &&
			Configuration::updateValue('COUNTCONFIG_38', '1') &&
			Configuration::updateValue('COUNTCONFIG_39', '0') &&
			Configuration::updateValue('COUNTCONFIG_40', '#000000');
			
		}
		public function uninstall()
		{
		if (!parent::uninstall() ||
			!Configuration::deleteByName('COUNTCONFIG_1') ||
			!Configuration::deleteByName('COUNTCONFIG_2') ||
			!Configuration::deleteByName('COUNTCONFIG_3') ||
			!Configuration::deleteByName('COUNTCONFIG_4') ||
			!Configuration::deleteByName('configcount_input1') ||
			!Configuration::deleteByName('configcount_input2') ||
			!Configuration::deleteByName('configcount_input3') ||
			!Configuration::deleteByName('configcount_input4') ||
			!Configuration::deleteByName('configcount_radio8') ||
			!Configuration::deleteByName('configcount_radio1') ||
			!Configuration::deleteByName('configcount_radio2') ||
			!Configuration::deleteByName('configcount_radio3') ||
			!Configuration::deleteByName('configcount_radio4') ||
			!Configuration::deleteByName('configcount_radio5') ||
			!Configuration::deleteByName('configcount_radio6') ||
			!Configuration::deleteByName('configcount_radio7') ||
			!Configuration::deleteByName('COUNTCONFIG_6') ||
			!Configuration::deleteByName('COUNTCONFIG_7') ||
			!Configuration::deleteByName('COUNTCONFIG_8') ||
			!Configuration::deleteByName('COUNTCONFIG_9') ||
			!Configuration::deleteByName('COUNTCONFIG_10') ||
			!Configuration::deleteByName('COUNTCONFIG_11') ||
			!Configuration::deleteByName('COUNTCONFIG_12') ||
			!Configuration::deleteByName('COUNTCONFIG_13') ||
			!Configuration::deleteByName('COUNTCONFIG_14') ||
			!Configuration::deleteByName('COUNTCONFIG_15') ||
			!Configuration::deleteByName('COUNTCONFIG_16') ||
			!Configuration::deleteByName('COUNTCONFIG_17') ||
			!Configuration::deleteByName('COUNTCONFIG_18') ||
			!Configuration::deleteByName('COUNTCONFIG_19') ||
			!Configuration::deleteByName('COUNTCONFIG_20') ||
			!Configuration::deleteByName('COUNTCONFIG_21') ||
			!Configuration::deleteByName('COUNTCONFIG_22') ||
			!Configuration::deleteByName('COUNTCONFIG_23') ||
			!Configuration::deleteByName('COUNTCONFIG_24') ||
			!Configuration::deleteByName('COUNTCONFIG_25') ||
			!Configuration::deleteByName('COUNTCONFIG_26') ||
			!Configuration::deleteByName('COUNTCONFIG_27') ||
			!Configuration::deleteByName('COUNTCONFIG_28') ||
			!Configuration::deleteByName('COUNTCONFIG_29') ||
			!Configuration::deleteByName('COUNTCONFIG_30') ||
			!Configuration::deleteByName('COUNTCONFIG_31') ||
			!Configuration::deleteByName('COUNTCONFIG_32') ||
			!Configuration::deleteByName('COUNTCONFIG_33') ||
			!Configuration::deleteByName('COUNTCONFIG_34') ||
			!Configuration::deleteByName('COUNTCONFIG_35') ||
			!Configuration::deleteByName('COUNTCONFIG_36') ||
			!Configuration::deleteByName('COUNTCONFIG_37') ||
			!Configuration::deleteByName('COUNTCONFIG_38') ||
			!Configuration::deleteByName('COUNTCONFIG_39') ||
			!Configuration::deleteByName('COUNTCONFIG_40'))
			return false;
			return true;
		}
		
		public function hookDisplayHeader()
{
	$this->context->controller->addCSS($this->_path.'css/jquery.ui.datepicker.css', 'all');
	$this->context->controller->addCSS($this->_path.'css/tetcountdown.css', 'all');
	$this->context->controller->addJS(($this->_path).'js/tetcountdown.js');
	$this->context->controller->addJS(($this->_path).'js/tetcountdown-main.js');

}
	public function hookdisplaytetcountdown($params)
		{
			$this->context->smarty->assign(array(
					'countconfig_4' => Configuration::get('COUNTCONFIG_4'),
					'countconfig_6' => Configuration::get('COUNTCONFIG_6'),
					'proconfigcountinput1' => Configuration::get('configcount_input1'),
					'proconfigcountradio1' => Configuration::get('configcount_radio1')
			));
			return $this->display(__FILE__, 'tetcountdown-banner.tpl');
		}
	
	protected function displayMainCountDown( $hook , $end_date = false)
	{
			$countconfig_1 = strval(Configuration::get('COUNTCONFIG_1', $this->context->language->id));
			$countconfig_2 = strval(Configuration::get('COUNTCONFIG_2', $this->context->language->id));
			$proconfigcountinput2 = strval(Configuration::get('configcount_input2', $this->context->language->id));
			$proconfigcountradio2 = strval(Configuration::get('configcount_radio2', $this->context->language->id));
			if(version_compare(_PS_VERSION_, '1.6.0.0', '<'))
				$countconfig_3 = Configuration::get('COUNTCONFIG_3').':00';		
			else	
				$countconfig_3 = Configuration::get('COUNTCONFIG_3');
			if( isset( $countconfig_3 ) && Validate::isDate($countconfig_3) && class_exists('DateTime')   )
			{
				$nb_minutes =  $this->compare_date($countconfig_3);

					if( $nb_minutes < 1 )
					return;
			}
			else
				return;
			$this->smarty->assign(array(
				'countconfig_1' => $countconfig_1,
				'countconfig_2' => $countconfig_2,
				'countconfig_3' => $countconfig_3,
				'proconfigcountinput2' => $proconfigcountinput2,
				'proconfigcountradio2' => $proconfigcountradio2
				
			));
			if( $hook == 'displayBanner'   )
			return $this->display(__FILE__, 'tetcountdown-footer.tpl');
	}
		protected function displayMainCountDownBanner( $hook , $end_date = false)
	{
			$countconfig_4 = strval(Configuration::get('COUNTCONFIG_4', $this->context->language->id));
			$proconfigcountinput1 = strval(Configuration::get('configcount_input1', $this->context->language->id));
			$proconfigcountradio1 = strval(Configuration::get('configcount_radio1', $this->context->language->id));
			if(version_compare(_PS_VERSION_, '1.6.0.0', '<'))
				$countconfig_6 = Configuration::get('COUNTCONFIG_6').':00';		
			else	
				$countconfig_6 = Configuration::get('COUNTCONFIG_6');
			if( isset( $countconfig_6 ) && Validate::isDate($countconfig_6) && class_exists('DateTime')   )
			{
				$nb_minutes =  $this->compare_date($countconfig_6);

					if( $nb_minutes < 1 )
					return;
			}
			else
				return;
			$this->smarty->assign(array(
				'countconfig_4' => $countconfig_4,
				'countconfig_6' => $countconfig_6,
				'proconfigcountinput2' => $proconfigcountinput2,
				'proconfigcountradio1' => $proconfigcountradio1
				
			));
			if( $hook == 'displayFooter')
			return $this->display(__FILE__, 'tetcountdown-banner.tpl');
	}
	
public function getContent()
{
			$output = null;
			if(version_compare(_PS_VERSION_, '1.6.0.0', '<'))
			{
			$this->context->controller->addJqueryUI('ui.slider');
			$this->context->controller->addJqueryUI('ui.datepicker');

			$this->context->controller->addCSS($this->_path.'css/jquery-ui-timepicker-addon.css','all');
			$this->context->controller->addJS($this->_path.'js/jquery-ui-timepicker-addon.js');

			$this->_html .= $this->ModuleDatepicker("datepickers", true);
			
			}
			if (Tools::isSubmit('submit'.$this->name))
			{
				$countconfig_1 = Tools::getValue('COUNTCONFIG_1');
				$countconfig_2 = Tools::getValue('COUNTCONFIG_2');
				$countconfig_3 = Tools::getValue('COUNTCONFIG_3');
				$countconfig_4 = Tools::getValue('COUNTCONFIG_4');
				$countconfig_6 = Tools::getValue('COUNTCONFIG_6');
				$countconfig_7 = Tools::getValue('COUNTCONFIG_7');
				$countconfig_8 = Tools::getValue('COUNTCONFIG_8');
				$countconfig_9 = Tools::getValue('COUNTCONFIG_9');
				$countconfig_10 = Tools::getValue('COUNTCONFIG_10');
				$countconfig_11 = Tools::getValue('COUNTCONFIG_11');
				$countconfig_12 = Tools::getValue('COUNTCONFIG_12');
				$countconfig_13 = Tools::getValue('COUNTCONFIG_13');
				$countconfig_14 = Tools::getValue('COUNTCONFIG_14');
				$countconfig_15 = Tools::getValue('COUNTCONFIG_15');
				$countconfig_16 = Tools::getValue('COUNTCONFIG_16');
				$countconfig_17 = Tools::getValue('COUNTCONFIG_17');
				$countconfig_18 = Tools::getValue('COUNTCONFIG_18');
				$countconfig_19 = Tools::getValue('COUNTCONFIG_19');
				$countconfig_20 = Tools::getValue('COUNTCONFIG_20');
				$countconfig_21 = Tools::getValue('COUNTCONFIG_21');
				$countconfig_22 = Tools::getValue('COUNTCONFIG_22');
				$countconfig_23 = Tools::getValue('COUNTCONFIG_23');
				$countconfig_24 = Tools::getValue('COUNTCONFIG_24');
				$countconfig_25 = Tools::getValue('COUNTCONFIG_25');
				$countconfig_26 = Tools::getValue('COUNTCONFIG_26');
				$countconfig_27 = Tools::getValue('COUNTCONFIG_27');
				$countconfig_28 = Tools::getValue('COUNTCONFIG_28');
				$countconfig_29 = Tools::getValue('COUNTCONFIG_29');
				$countconfig_30 = Tools::getValue('COUNTCONFIG_30');
				$countconfig_31 = Tools::getValue('COUNTCONFIG_31');
				$countconfig_32 = Tools::getValue('COUNTCONFIG_32');
				$countconfig_33 = Tools::getValue('COUNTCONFIG_33');
				$countconfig_34 = Tools::getValue('COUNTCONFIG_34');
				$countconfig_35 = Tools::getValue('COUNTCONFIG_35');
				$countconfig_36 = Tools::getValue('COUNTCONFIG_36');
				$countconfig_37 = Tools::getValue('COUNTCONFIG_37');
				$countconfig_38 = Tools::getValue('COUNTCONFIG_38');
				$countconfig_39 = Tools::getValue('COUNTCONFIG_39');
				$countconfig_40 = Tools::getValue('COUNTCONFIG_40');
				$proconfigcountinput1 = Tools::getValue('configcount_input1');
				$proconfigcountinput2 = Tools::getValue('configcount_input2');
				$proconfigcountinput3 = Tools::getValue('configcount_input3');
				$proconfigcountinput4 = Tools::getValue('configcount_input4');
				$proconfigcountradio1 = Tools::getValue('configcount_radio1');
				$proconfigcountradio2 = Tools::getValue('configcount_radio2');
				$proconfigcountradio3 = Tools::getValue('configcount_radio3');
				$proconfigcountradio4 = Tools::getValue('configcount_radio4');
				$proconfigcountradio5 = Tools::getValue('configcount_radio5');
				$proconfigcountradio6 = Tools::getValue('configcount_radio6');
				$proconfigcountradio7 = Tools::getValue('configcount_radio7');
				$proconfigcountradio8 = Tools::getValue('configcount_radio8');
					Configuration::updateValue('COUNTCONFIG_1', $countconfig_1, true);
					Configuration::updateValue('COUNTCONFIG_2', $countconfig_2, true);	
					Configuration::updateValue('COUNTCONFIG_3', $countconfig_3);
					Configuration::updateValue('COUNTCONFIG_4', $countconfig_4, true);
					Configuration::updateValue('COUNTCONFIG_6', $countconfig_6);
					Configuration::updateValue('COUNTCONFIG_7', $countconfig_7);
					Configuration::updateValue('COUNTCONFIG_8', $countconfig_8);
					Configuration::updateValue('COUNTCONFIG_9', $countconfig_9);
					Configuration::updateValue('COUNTCONFIG_10', $countconfig_10);
					Configuration::updateValue('COUNTCONFIG_11', $countconfig_11);
					Configuration::updateValue('COUNTCONFIG_12', $countconfig_12);
					Configuration::updateValue('COUNTCONFIG_13', $countconfig_13);
					Configuration::updateValue('COUNTCONFIG_14', $countconfig_14);
					Configuration::updateValue('COUNTCONFIG_15', $countconfig_15);
					Configuration::updateValue('COUNTCONFIG_16', $countconfig_16);
					Configuration::updateValue('COUNTCONFIG_17', $countconfig_17);
					Configuration::updateValue('COUNTCONFIG_18', $countconfig_18);
					Configuration::updateValue('COUNTCONFIG_19', $countconfig_19);
					Configuration::updateValue('COUNTCONFIG_20', $countconfig_20);
					Configuration::updateValue('COUNTCONFIG_21', $countconfig_21);
					Configuration::updateValue('COUNTCONFIG_22', $countconfig_22);
					Configuration::updateValue('COUNTCONFIG_23', $countconfig_23);
					Configuration::updateValue('COUNTCONFIG_24', $countconfig_24);
					Configuration::updateValue('COUNTCONFIG_25', $countconfig_25);
					Configuration::updateValue('COUNTCONFIG_26', $countconfig_26);
					Configuration::updateValue('COUNTCONFIG_27', $countconfig_27);
					Configuration::updateValue('COUNTCONFIG_28', $countconfig_28);
					Configuration::updateValue('COUNTCONFIG_29', $countconfig_29);
					Configuration::updateValue('COUNTCONFIG_30', $countconfig_30);
					Configuration::updateValue('COUNTCONFIG_31', $countconfig_31);
					Configuration::updateValue('COUNTCONFIG_32', $countconfig_32);
					Configuration::updateValue('COUNTCONFIG_33', $countconfig_33);
					Configuration::updateValue('COUNTCONFIG_34', $countconfig_34);
					Configuration::updateValue('COUNTCONFIG_35', $countconfig_35);
					Configuration::updateValue('COUNTCONFIG_36', $countconfig_36);
					Configuration::updateValue('COUNTCONFIG_37', $countconfig_37);
					Configuration::updateValue('COUNTCONFIG_38', $countconfig_38);
					Configuration::updateValue('COUNTCONFIG_39', $countconfig_39);
					Configuration::updateValue('COUNTCONFIG_40', $countconfig_40);
					Configuration::updateValue('configcount_input1', $proconfigcountinput1);
					Configuration::updateValue('configcount_input2', $proconfigcountinput2);
					Configuration::updateValue('configcount_input3', $proconfigcountinput3);
					Configuration::updateValue('configcount_input4', $proconfigcountinput4);
					Configuration::updateValue('configcount_radio1', $proconfigcountradio1);
					Configuration::updateValue('configcount_radio2', $proconfigcountradio2);
					Configuration::updateValue('configcount_radio3', $proconfigcountradio3);
					Configuration::updateValue('configcount_radio4', $proconfigcountradio4);
					Configuration::updateValue('configcount_radio5', $proconfigcountradio5);
					Configuration::updateValue('configcount_radio6', $proconfigcountradio6);
					Configuration::updateValue('configcount_radio7', $proconfigcountradio7);
					Configuration::updateValue('configcount_radio8', $proconfigcountradio8);
					$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
			return $output.$this->displayForm();
		}		
public function displayForm()
{	
			$iso = Language::getIsoById($this->context->employee->id_lang);
			$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
			$ad = dirname($_SERVER["PHP_SELF"]);
			$form='
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
			<script type="text/javascript">
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
			$(document).ready(function(){
			tinyMCE.init({
			mode : "specific_textareas",
    	    theme : "advanced",
    		 skin:"cirkuit",
    		 editor_selector :"rte",
        		theme_advanced_buttons1 : "code, save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,fontselect,fontsizeselect",
        		theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,codemagic,|,insertdate,inserttime,preview,|,forecolor,backcolor",
        		theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
        		theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak,restoredraft,visualblocks",
        		theme_advanced_toolbar_location : "top",
        		theme_advanced_toolbar_align : "left",
        		theme_advanced_statusbar_location : "bottom",
        		theme_advanced_resizing : false,
                extended_valid_elements: \'pre[*],script[*],style[*]\',
                valid_children: "+body[style|script],pre[script|div|p|br|span|img|style|h1|h2|h3|h4|h5]",
                force_p_newlines : false,
                cleanup: false,
                forced_root_block : false,
                force_br_newlines : true
				});
			});
			function addClass(id){                    
				tinyMCE.execCommand(\'mceAddControl\', true, \'htmlbox_body\');
			}
			function removeClass(id){
				tinyMCE.execCommand(\'mceRemoveControl\', false, \'htmlbox_body\');
			}			
			</script>
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>
			';  
			$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Position Header.'),
				),
				
				'input' => array(
					array(
						'type' => 'switch',
						'label' => $this->l('Display:'),
						'name' => 'configcount_radio1',
						'class' => 't',
						'desc' => $this->l('Display hook header "Banner".'),
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Enabled')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('Disabled')
							)
						)
					),
					array(
						'name' => 'COUNTCONFIG_6',
						'type' => 'datetime',
						'label' => $this->l('End date:'),
						'desc' => $this->l('Select Date for the end of CountDown')
					),
					array(
						'type' => 'textarea',
						'label' => $this->l('Text:'),
						'name' => 'COUNTCONFIG_4',
						'cols' => 40,
						'rows' => 3,
						'class' => 'rte',
						'desc' => $this->l('Enter your text top.'),
						'autoload_rte' => true
					),
					array(
						'type' => 'color',
						'label' => $this->l('Background:'),
						'name' => 'configcount_input1',
                     	'class' => 'color mColorPickerInput',
                   		'size' => 20,
                  		'desc' => $this->l('Change background number CountDown.')
		    		)
				),
				'submit' => array(
					'title' => $this->l('Save'),
					'class' => 'button'
				)
				),
			);
			
			

		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table =  $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submit'.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);
				$helper->fields_value['COUNTCONFIG_1'] = Configuration::get('COUNTCONFIG_1');
				$helper->fields_value['COUNTCONFIG_2'] = Configuration::get('COUNTCONFIG_2');
				$helper->fields_value['COUNTCONFIG_3'] = Configuration::get('COUNTCONFIG_3');
				$helper->fields_value['COUNTCONFIG_4'] = Configuration::get('COUNTCONFIG_4');
				$helper->fields_value['COUNTCONFIG_6'] = Configuration::get('COUNTCONFIG_6');
				$helper->fields_value['COUNTCONFIG_7'] = Configuration::get('COUNTCONFIG_7');
				$helper->fields_value['COUNTCONFIG_8'] = Configuration::get('COUNTCONFIG_8');
				$helper->fields_value['COUNTCONFIG_9'] = Configuration::get('COUNTCONFIG_9');
				$helper->fields_value['COUNTCONFIG_10'] = Configuration::get('COUNTCONFIG_10');
				$helper->fields_value['COUNTCONFIG_11'] = Configuration::get('COUNTCONFIG_11');
				$helper->fields_value['COUNTCONFIG_12'] = Configuration::get('COUNTCONFIG_12');
				$helper->fields_value['COUNTCONFIG_13'] = Configuration::get('COUNTCONFIG_13');
				$helper->fields_value['COUNTCONFIG_14'] = Configuration::get('COUNTCONFIG_14');
				$helper->fields_value['COUNTCONFIG_15'] = Configuration::get('COUNTCONFIG_15');
				$helper->fields_value['COUNTCONFIG_16'] = Configuration::get('COUNTCONFIG_16');
				$helper->fields_value['COUNTCONFIG_17'] = Configuration::get('COUNTCONFIG_17');
				$helper->fields_value['COUNTCONFIG_18'] = Configuration::get('COUNTCONFIG_18');
				$helper->fields_value['COUNTCONFIG_19'] = Configuration::get('COUNTCONFIG_19');
				$helper->fields_value['COUNTCONFIG_20'] = Configuration::get('COUNTCONFIG_20');
				$helper->fields_value['COUNTCONFIG_21'] = Configuration::get('COUNTCONFIG_21');
				$helper->fields_value['COUNTCONFIG_22'] = Configuration::get('COUNTCONFIG_22');
				$helper->fields_value['COUNTCONFIG_23'] = Configuration::get('COUNTCONFIG_23');
				$helper->fields_value['COUNTCONFIG_24'] = Configuration::get('COUNTCONFIG_24');
				$helper->fields_value['COUNTCONFIG_25'] = Configuration::get('COUNTCONFIG_25');
				$helper->fields_value['COUNTCONFIG_26'] = Configuration::get('COUNTCONFIG_26');
				$helper->fields_value['COUNTCONFIG_27'] = Configuration::get('COUNTCONFIG_27');
				$helper->fields_value['COUNTCONFIG_28'] = Configuration::get('COUNTCONFIG_28');
				$helper->fields_value['COUNTCONFIG_29'] = Configuration::get('COUNTCONFIG_29');
				$helper->fields_value['COUNTCONFIG_30'] = Configuration::get('COUNTCONFIG_30');
				$helper->fields_value['COUNTCONFIG_31'] = Configuration::get('COUNTCONFIG_31');
				$helper->fields_value['COUNTCONFIG_32'] = Configuration::get('COUNTCONFIG_32');
				$helper->fields_value['COUNTCONFIG_33'] = Configuration::get('COUNTCONFIG_33');
				$helper->fields_value['COUNTCONFIG_34'] = Configuration::get('COUNTCONFIG_34');
				$helper->fields_value['COUNTCONFIG_35'] = Configuration::get('COUNTCONFIG_35');
				$helper->fields_value['COUNTCONFIG_36'] = Configuration::get('COUNTCONFIG_36');
				$helper->fields_value['COUNTCONFIG_37'] = Configuration::get('COUNTCONFIG_37');
				$helper->fields_value['COUNTCONFIG_38'] = Configuration::get('COUNTCONFIG_38');
				$helper->fields_value['COUNTCONFIG_39'] = Configuration::get('COUNTCONFIG_39');
				$helper->fields_value['COUNTCONFIG_40'] = Configuration::get('COUNTCONFIG_40');
				$helper->fields_value['configcount_input1'] = Configuration::get('configcount_input1');
				$helper->fields_value['configcount_input2'] = Configuration::get('configcount_input2');
				$helper->fields_value['configcount_input3'] = Configuration::get('configcount_input3');
				$helper->fields_value['configcount_input4'] = Configuration::get('configcount_input4');
				$helper->fields_value['configcount_radio1'] = Configuration::get('configcount_radio1');
				$helper->fields_value['configcount_radio2'] = Configuration::get('configcount_radio2');
				$helper->fields_value['configcount_radio3'] = Configuration::get('configcount_radio3');
				$helper->fields_value['configcount_radio4'] = Configuration::get('configcount_radio4');
				$helper->fields_value['configcount_radio5'] = Configuration::get('configcount_radio5');
				$helper->fields_value['configcount_radio6'] = Configuration::get('configcount_radio6');
				$helper->fields_value['configcount_radio7'] = Configuration::get('configcount_radio7');
				$helper->fields_value['configcount_radio8'] = Configuration::get('configcount_radio8');  
				return $helper->generateForm(array($fields_form));
}			

public function compare_date( $date1 , $date2  =  false ) 
	{
	if( class_exists('DateTime') && method_exists('DateTime','diff')  )
	{
		if( isset( $date2 ) )
		$date2 =  date('Y-m-d h:i' );
		$datetime1 = new DateTime($date2);
		$datetime2 = new DateTime($date1);
		$interval = $datetime1->diff($datetime2);
		return $interval->format(' %I ');
	}
	else
	{ 
		$datetime1 = new DateTime($date2);
		$datetime2 = new DateTime($date1);
		if( $datetime1 < $datetime2 )
			return 1;
		else
			return -1;
	}	
}


public function getConfigFieldsValues()
{
		return array(
			'COUNTCONFIG_1' => Tools::getValue('COUNTCONFIG_1', Configuration::get('COUNTCONFIG_1')),
			'COUNTCONFIG_2' => Tools::getValue('COUNTCONFIG_2', Configuration::get('COUNTCONFIG_2')),
			'COUNTCONFIG_3' => Tools::getValue('COUNTCONFIG_3', Configuration::get('COUNTCONFIG_3')),
			'COUNTCONFIG_4' => Tools::getValue('COUNTCONFIG_4', Configuration::get('COUNTCONFIG_4')),
			'COUNTCONFIG_6' => Tools::getValue('COUNTCONFIG_6', Configuration::get('COUNTCONFIG_6')),
			'COUNTCONFIG_7' => Tools::getValue('COUNTCONFIG_7', Configuration::get('COUNTCONFIG_7')),
			'COUNTCONFIG_8' => Tools::getValue('COUNTCONFIG_8', Configuration::get('COUNTCONFIG_8')),
			'COUNTCONFIG_9' => Tools::getValue('COUNTCONFIG_9', Configuration::get('COUNTCONFIG_9')),
			'COUNTCONFIG_10' => Tools::getValue('COUNTCONFIG_10', Configuration::get('COUNTCONFIG_10')),
			'COUNTCONFIG_11' => Tools::getValue('COUNTCONFIG_11', Configuration::get('COUNTCONFIG_11')),
			'COUNTCONFIG_12' => Tools::getValue('COUNTCONFIG_12', Configuration::get('COUNTCONFIG_12')),
			'COUNTCONFIG_13' => Tools::getValue('COUNTCONFIG_13', Configuration::get('COUNTCONFIG_13')),
			'COUNTCONFIG_14' => Tools::getValue('COUNTCONFIG_14', Configuration::get('COUNTCONFIG_14')),
			'COUNTCONFIG_15' => Tools::getValue('COUNTCONFIG_15', Configuration::get('COUNTCONFIG_15')),
			'COUNTCONFIG_16' => Tools::getValue('COUNTCONFIG_16', Configuration::get('COUNTCONFIG_16')),
			'COUNTCONFIG_17' => Tools::getValue('COUNTCONFIG_17', Configuration::get('COUNTCONFIG_17')),
			'COUNTCONFIG_18' => Tools::getValue('COUNTCONFIG_18', Configuration::get('COUNTCONFIG_18')),
			'COUNTCONFIG_19' => Tools::getValue('COUNTCONFIG_19', Configuration::get('COUNTCONFIG_19')),
			'COUNTCONFIG_20' => Tools::getValue('COUNTCONFIG_20', Configuration::get('COUNTCONFIG_20')),
			'COUNTCONFIG_21' => Tools::getValue('COUNTCONFIG_21', Configuration::get('COUNTCONFIG_21')),
			'COUNTCONFIG_22' => Tools::getValue('COUNTCONFIG_22', Configuration::get('COUNTCONFIG_22')),
			'COUNTCONFIG_23' => Tools::getValue('COUNTCONFIG_23', Configuration::get('COUNTCONFIG_23')),
			'COUNTCONFIG_24' => Tools::getValue('COUNTCONFIG_24', Configuration::get('COUNTCONFIG_24')),
			'COUNTCONFIG_25' => Tools::getValue('COUNTCONFIG_25', Configuration::get('COUNTCONFIG_25')),
			'COUNTCONFIG_26' => Tools::getValue('COUNTCONFIG_26', Configuration::get('COUNTCONFIG_26')),
			'COUNTCONFIG_27' => Tools::getValue('COUNTCONFIG_27', Configuration::get('COUNTCONFIG_27')),
			'COUNTCONFIG_28' => Tools::getValue('COUNTCONFIG_28', Configuration::get('COUNTCONFIG_28')),
			'COUNTCONFIG_29' => Tools::getValue('COUNTCONFIG_29', Configuration::get('COUNTCONFIG_29')),
			'COUNTCONFIG_30' => Tools::getValue('COUNTCONFIG_30', Configuration::get('COUNTCONFIG_30')),
			'COUNTCONFIG_31' => Tools::getValue('COUNTCONFIG_31', Configuration::get('COUNTCONFIG_31')),
			'COUNTCONFIG_32' => Tools::getValue('COUNTCONFIG_32', Configuration::get('COUNTCONFIG_32')),
			'COUNTCONFIG_33' => Tools::getValue('COUNTCONFIG_33', Configuration::get('COUNTCONFIG_33')),
			'COUNTCONFIG_34' => Tools::getValue('COUNTCONFIG_34', Configuration::get('COUNTCONFIG_34')),
			'COUNTCONFIG_35' => Tools::getValue('COUNTCONFIG_35', Configuration::get('COUNTCONFIG_35')),
			'COUNTCONFIG_36' => Tools::getValue('COUNTCONFIG_36', Configuration::get('COUNTCONFIG_36')),
			'COUNTCONFIG_37' => Tools::getValue('COUNTCONFIG_37', Configuration::get('COUNTCONFIG_37')),
			'COUNTCONFIG_38' => Tools::getValue('COUNTCONFIG_38', Configuration::get('COUNTCONFIG_38')),
			'COUNTCONFIG_39' => Tools::getValue('COUNTCONFIG_39', Configuration::get('COUNTCONFIG_39')),
			'COUNTCONFIG_40' => Tools::getValue('COUNTCONFIG_40', Configuration::get('COUNTCONFIG_40')),
			'configcount_input1' => Tools::getValue('configcount_input1', Configuration::get('configcount_input1')),
			'configcount_input2' => Tools::getValue('configcount_input2', Configuration::get('configcount_input2')),
			'configcount_input3' => Tools::getValue('configcount_input3', Configuration::get('configcount_input3')),
			'configcount_input4' => Tools::getValue('configcount_input4', Configuration::get('configcount_input4')),
			'configcount_radio1' => Tools::getValue('configcount_radio1', Configuration::get('configcount_radio1')),
			'configcount_radio2' => Tools::getValue('configcount_radio2', Configuration::get('configcount_radio2')),
			'configcount_radio3' => Tools::getValue('configcount_radio3', Configuration::get('configcount_radio3')),
			'configcount_radio4' => Tools::getValue('configcount_radio4', Configuration::get('configcount_radio4')),
			'configcount_radio5' => Tools::getValue('configcount_radio5', Configuration::get('configcount_radio5')),
			'configcount_radio6' => Tools::getValue('configcount_radio6', Configuration::get('configcount_radio6')),
			'configcount_radio7' => Tools::getValue('configcount_radio7', Configuration::get('configcount_radio7')),
			'configcount_radio8' => Tools::getValue('configcount_radio8', Configuration::get('configcount_radio8'))
		);
}

private function ModuleDatepicker($class, $time)
{
		return '
			<script type="text/javascript">
			$(function() { 
				$("#countconfig_3").datetimepicker({
					dateFormat: "yy-mm-dd"
				});
			});
				$(function() { 
				$("#countconfig_4").datetimepicker({
					dateFormat: "yy-mm-dd"
				});
			});
			</script>';
}

}
?>