<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
exit;

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class LABManufacture extends Module implements WidgetInterface
{

public function __construct()
{
		$this->name = 'labmanufacture';
		$this->tab = 'front_office_features';
		$this->version = '1.7.x';
		$this->author = 'laberthemes';
		$this->module_key = '';
		parent::__construct();
		$this->displayName = $this->getTranslator()->trans('LABER Manufacturer Logo Slider', array(), 'Modules.LABManufacture.Admin');
		$this->description = $this->getTranslator()->trans('Adds Slider of Manufacturer logo on your site.', array(), 'Modules.LABManufacture.Admin');
		$this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
}

public function install()
{
		if (!parent::install() || !$this->registerHook('header') || !$this->registerHook('displayManufacture'))
			return false;
		return true;
}

public function uninstall()
{
		if (parent::uninstall() == false)
			return false;
		return true;
}

public function hookHeader($params)
{
		
}

	public function getWidgetVariables($hookName = null, array $configuration = [])
    {
		$list_manu = Manufacturer::getManufacturers(false, 0, true);
	
		return [
           'list_manu' => $list_manu,
			'manu_img_dir' => _PS_MANU_IMG_DIR_,
			'path_ssl' => $this->context->link->getBaseLink()
        ];
	}
	
	
	public function renderWidget($hookName = null, array $configuration = [])
    {
        $this->smarty->assign($this->getWidgetVariables($hookName, $configuration));

        return $this->fetch('module:'.$this->name.'/views/templates/hook/'.$this->name.'.tpl', $this->getCacheId());
    }
	
	
}